/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileOpenPacket;
import com.ibm.hsc.filesvr.FsFileOpenRequestPacket;
import com.ibm.hsc.filesvr.FsPacket;
import java.io.RandomAccessFile;

public class FsFileOpenResponsePacket
extends FsFileOpenPacket {
    protected long m_fileHandle = -1L;

    protected FsFileOpenResponsePacket(FsConnection fsConnection) {
        super(fsConnection);
    }

    protected FsFileOpenResponsePacket(FsPacket fsPacket) {
        super(fsPacket);
    }

    protected FsFileOpenResponsePacket(FsFileOpenPacket fsFileOpenPacket) {
        super(fsFileOpenPacket);
    }

    protected FsFileOpenResponsePacket(FsFileOpenResponsePacket fsFileOpenResponsePacket) {
        super(fsFileOpenResponsePacket);
        if (fsFileOpenResponsePacket != null) {
            this.m_fileHandle = fsFileOpenResponsePacket.m_fileHandle;
        }
    }

    public FsFileOpenResponsePacket(FsFileOpenRequestPacket fsFileOpenRequestPacket) {
        super(fsFileOpenRequestPacket);
        this.setResponsePacket();
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (!this.isResponsePacket()) {
            throw new FsException(20);
        }
        this.m_fileHandle = this.m_connection.openFile(this.m_fileType, this.m_fileName, true);
        RandomAccessFile randomAccessFile = this.m_connection.getOpenFile(this.m_fileHandle);
        if (randomAccessFile == null) {
            throw new FsException(256);
        }
        fsByteStream.writeLong(this.m_fileHandle);
    }

    public long getFileHandle() {
        return this.m_fileHandle;
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (!this.isResponsePacket()) {
            throw new FsException(20);
        }
        this.m_fileHandle = fsByteStream.readLong();
    }
}

